﻿using System;
using System.Collections.Generic;
using System.Text;


namespace ComplexLib
{
    public class Complex
    {
        // Grenze für eine Prüfung auf 0
        internal static double null_grenze = 0.0000001;

        // Ausgabeformat für Stringoperationen
        internal static int default_vorkomma = 4;
        internal static int default_nachkomma = 2;

        // Komponenten der komplexen Zahl
        public double real { get; set; }
        public double i { get; set; }

        // Konstruktor
        public Complex(double r, double i)
        {
            this.real = r;
            this.i = i;
        }

        // Ausgabeformat für Stringmethoden setzen
        public static void set_format(int vor, int nach)
        {
            default_vorkomma = vor;
            default_nachkomma = nach;
        }

        // Implementierung der Additionsoperation zweier komplexer Zahlen
        public static Complex operator +(Complex z1, Complex z2)
        {
            double realteil = 0.0;
            double imaginaerteil = 0.0;

            realteil = z1.real + z2.real;
            imaginaerteil = z1.i + z2.i;

            return new Complex(realteil, imaginaerteil);
        }

        // Implementierung der Subtraktionsoperation zweier komplexer Zahlen
        public static Complex operator -(Complex z1, Complex z2)
        {
            double realteil = 0.0;
            double imaginaerteil = 0.0;

            realteil = z1.real - z2.real;
            imaginaerteil = z1.i - z2.i;

            return new Complex(realteil, imaginaerteil);
        }

        // Implementierung der Multiplikationsoperation zweier komplexer Zahlen
        public static Complex operator *(Complex z1, Complex z2)
        {
            double realteil = 0.0;
            double imaginaerteil = 0.0;

            realteil = z1.real * z2.real - z1.i * z2.i;
            imaginaerteil = z1.real * z2.i + z2.real * z1.i;

            return new Complex(realteil, imaginaerteil);
        }

        // Implementierung der Divisionsoperation zweier komplexer Zahlen
        public static Complex operator /(Complex z1, Complex z2)
        {
            double realteil = 0.0;
            double imaginaerteil = 0.0;

            double nenner = z2.real * z2.real + z2.i * z2.i;

            // Division durch eine Zahl im Bereich 0 ist verhindern!
            if (Math.Abs(nenner) < null_grenze) throw new FormatException("Division nicht möglich da Divisorbetrag zu klein!");

            realteil      = (z1.real * z2.real + z1.i * z2.i) / nenner;
            imaginaerteil = (z1.i * z2.real - z2.i * z1.real) / nenner;

            return new Complex(realteil, imaginaerteil);
        }

        // Betrag einer komplexen Zahl zurückgeben
        public static double betrag(Complex z)
        {
            return Math.Sqrt( z.real * z.real + z.i*z.i);
        }

        // Betrag der Instanz zurückgeben
        public double betrag()
        {
            return Math.Sqrt(this.real * this.real + this.i * this.i);
        }

        // Betrag der Instanz als formattierten String zurückgeben
        public string betrag_str()
        {
            double betrag = 0.0;
            string ret;

            betrag = Math.Sqrt(this.real * this.real + this.i * this.i);
            ret = dbl2str(betrag);

            return ret;
        }

        // Form: a + bi erwartet (auch negative Werte wie -a -bi)
        public static Complex Parse(string str)
        {
            double realteil = 0.0;
            double imaginaerteil = 0.0;
            char[] chars;
            int anzahl_vorzeichen = 0;
            int anzahl_i = 0;
            bool erstes_vorzeichen_minus  = false;
            bool zweites_vorzeichen_minus = false;
            bool trennzeichen_minus = false;
            bool realteil_minus = false;


            // Leerzeichen entfernen
            str = str.Replace(" ", "");

            // Dezimalbruch ist Komma
            str = str.Replace(".", ",");

            // Format prüfen (Anzahl Vorzeichen, genau 1 Imaginärteil vorhanden)
            chars = str.ToCharArray();
            foreach (char c in chars)
            {
                if (c == '-') {
                    anzahl_vorzeichen++;
                    if (anzahl_vorzeichen == 1) erstes_vorzeichen_minus = true;
                    else zweites_vorzeichen_minus = true;
                }
                if (c == '+') anzahl_vorzeichen++;
                if (c == 'i') anzahl_i++;
            }

            // Formatfehler prüfen
            if (anzahl_vorzeichen != 1 && anzahl_vorzeichen != 2) throw new FormatException("Form: a + bi, Anzahl der Vorzeichen prüfen!");
            if (anzahl_i != 1)throw new FormatException("Form: a + bi, bitte genau ein Imaginärteil (i)!");

            // Haben beide Teile Vorzeichen, dann ist Trennung der Komponenten durch Vorzeichen nur möglich, wenn Realteilvorzeichen entfernt wird
            if (anzahl_vorzeichen == 2) {
                string zeichen1 = str.Substring(0,1);
                if ( !( (zeichen1.Equals("+") || zeichen1.Equals("-") ) ) ) throw new FormatException("Form: a + bi, Vorzeichenpositionen prüfen!");
                if (zeichen1.Equals("-")) realteil_minus = true;
                
                // Vorzeichen Realteil entfernen
                str = str.Substring(1,str.Length-1);

                // Trennzeichen = 2. Vorzeichen
                trennzeichen_minus = zweites_vorzeichen_minus;
            }

            // Trennzeichen = 1. Vorzeichen, String aufteilen
            trennzeichen_minus = erstes_vorzeichen_minus;
            char trennzeichen = (trennzeichen_minus) ? '-' : '+';
            string[] array = str.Split(trennzeichen);

            // Imaginärzeichen aus Imaninärteil entfernen
            array[1] = array[1].Replace("i","");
            realteil = Double.Parse(array[0]);
            imaginaerteil = Double.Parse(array[1]);

            // Vorzeichen der Teile beachten
            if(realteil_minus) realteil = - realteil;
            if(trennzeichen_minus) imaginaerteil = - imaginaerteil;

            return new Complex(realteil, imaginaerteil);
        }   
            
        public override string ToString()
        {
            string verbindung;
            double i_betrag = i;

            // Bei negativem Imaginärteil nur Betrag ausgeben
            bool vorzeichen_i_minus = false;
            if (i < 0.0)
            {
                vorzeichen_i_minus = true;
                i_betrag = -i_betrag;
            }

            // Korrektes Verbindungszeichen setzen
            verbindung = (vorzeichen_i_minus) ? " - " : " + ";


            // Komponenten in Strings konvertieren
            string realteil = dbl2str(this.real);
            string imaginaerteil = dbl2str(i_betrag);

            return realteil + verbindung + imaginaerteil + "i";
        }

        // Double konvertieren, Format beachten und bei Werten unter Betrag 1 eine 0 vor dem Komma hinzufügen
        internal string dbl2str(double dbl)
        {
            String ret = "";
            String formatstr="";

            for (int zaehler = 0; zaehler < default_vorkomma; zaehler++) formatstr += "#";
            formatstr += ".";
            for (int zaehler = 0; zaehler < default_nachkomma; zaehler++) formatstr += "#";

            ret = dbl.ToString(formatstr).Trim();

            if (ret.Length == 0) ret = "0";

            if (ret.Length > 1)
            {
                if (ret.Substring(0, 1).Equals(",")) ret = "0" + ret;
                if (ret.Substring(0, 1).Equals("-") && ret.Substring(1, 1).Equals(",")) ret = "-0," + ret.Substring(2, ret.Length - 2);
            }

            return ret;
        }

    }
}
